/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.tinkers_ingenuity.generic.Interface.curio;

import com.xiaoyue.tinkers_ingenuity.content.library.context.CurioAttributeContext;
import java.util.Collection;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import top.theillusivec4.curios.api.SlotContext;

public interface CurioBuilderHook {
    public static final CurioBuilderHook EMPTY = new CurioBuilderHook(){};

    default public void onCurioTick(IToolStackView curio, SlotContext context, LivingEntity entity, int level, ItemStack stack) {
    }

    default public void addCurioAttribute(IToolStackView curio, SlotContext context, LivingEntity entity, int level, ItemStack stack, CurioAttributeContext attr) {
    }

    default public void onCurioEquip(IToolStackView curio, SlotContext context, LivingEntity entity, int level, ItemStack prevStack, ItemStack stack) {
    }

    default public void onCurioUnequip(IToolStackView curio, SlotContext context, LivingEntity entity, int level, ItemStack newStack, ItemStack stack) {
    }

    public record AllMerger(Collection<CurioBuilderHook> modules) implements CurioBuilderHook
    {
        @Override
        public void onCurioTick(IToolStackView curio, SlotContext context, LivingEntity entity, int level, ItemStack stack) {
            for (CurioBuilderHook module : this.modules) {
                module.onCurioTick(curio, context, entity, level, stack);
            }
        }

        @Override
        public void addCurioAttribute(IToolStackView curio, SlotContext context, LivingEntity entity, int level, ItemStack stack, CurioAttributeContext attr) {
            for (CurioBuilderHook module : this.modules) {
                module.addCurioAttribute(curio, context, entity, level, stack, attr);
            }
        }

        @Override
        public void onCurioEquip(IToolStackView curio, SlotContext context, LivingEntity entity, int level, ItemStack prevStack, ItemStack stack) {
            for (CurioBuilderHook module : this.modules) {
                module.onCurioEquip(curio, context, entity, level, prevStack, stack);
            }
        }

        @Override
        public void onCurioUnequip(IToolStackView curio, SlotContext context, LivingEntity entity, int level, ItemStack newStack, ItemStack stack) {
            for (CurioBuilderHook module : this.modules) {
                module.onCurioUnequip(curio, context, entity, level, newStack, stack);
            }
        }
    }
}

